#ifndef SI5351A_OPTIMIZED_H
#define SI5351A_OPTIMIZED_H

#include <inttypes.h>

#define SI5351_ADDRESS      0x60
#define SI_CLK0_CONTROL     0x10
#define SI_CLK1_CONTROL     0x11
#define SI_CLK2_CONTROL     0x12
#define SI_SYNTH_PLL_A      0x1A
#define SI_SYNTH_MS_0       0x2A

#define SI_R_DIV_1          0x00
#define SI_CLK_SRC_PLL_A    0x00

void si5351a_fast_init(void);
void si5351a_set_frequency_fast(uint32_t freq);
void si5351a_burst_write(uint8_t start_reg, const uint8_t *data, uint8_t length);
void si5351aSetFrequency(uint32_t frequency);
void si5351aSetFrequencyOptimized(uint32_t frequency);

// Новые функции для улучшенного целочисленного режима
uint8_t find_integer_mode_solution(uint32_t target_freq, uint8_t *best_mult, uint32_t *best_divider);
void optimize_for_integer_mode(void);

#endif
