#ifndef MAIN_H
#define MAIN_H

#include <avr/io.h>
#include <stdint.h>

// Определения пинов
#define ENCODER_PIN1 2  // PD2
#define ENCODER_PIN2 3  // PD3

// Пины для сдвигового регистра переключения диапазонов
#define SHIFT_DATA  4   // PD4
#define SHIFT_CLK   5   // PD5  
#define SHIFT_LATCH 6   // PD6

// Пины для ГУНов 
#define VCO_39_48  4    // PB4
#define VCO_46_57  5    // PB5
#define VCO_55_69  2    // PC2  
#define VCO_68_82  3    // PC3

// Пин ADC для кнопок и S-meter 
#define BUTTON_ADC_PIN 0 // PC0
#define SMETER_ADC_PIN 1 // PC1

// Константы
#define DEBOUNCE_DELAY 5
#define RIT_MAX_OFFSET 5000  //Расстройка RIT 5 кГц

// S-meter константы
#define SMETER_UPDATE_INTERVAL 10  // Обновление s-meter каждые 10 циклов
#define SMETER_THRESHOLDS_COUNT 11
#define SMETER_MAX_RAW 1023

// Определения кнопок
#define BUTTON_COUNT 6
typedef enum {
    BUTTON_NONE = 0,
    BUTTON_BAND_UP = 1,
    BUTTON_BAND_DN = 2, 
    BUTTON_STEP = 3,
    BUTTON_RIT = 4,
    BUTTON_PTT = 5
} button_t;

// Прототипы функций
void setup(void);
void processEncoder(void);
void handleButtons(void);
void updateVCO(uint32_t receiveFrequency);
void updateBandSwitches(uint8_t band);
void changeBand(uint8_t newBand);
button_t readButtonADC(void);
void shiftOut(uint16_t data);
void shiftRegisterInit(void);
void handleButtonPress(button_t button);
void handleButtonRelease(button_t button);
void updateDisplay(uint32_t freq);
void updateSMeter(void);
uint16_t readSMeterADC(void);
const char* getSMeterString(uint16_t adcValue);

// Внешние переменные
extern volatile int8_t encoderCount;
extern volatile uint32_t frequency;
extern volatile uint32_t currentFrequency;
extern volatile uint32_t stepSize;
extern volatile int32_t ritOffset;
extern volatile uint8_t ritEnabled;
extern volatile uint8_t pttPressed;
extern volatile uint8_t currentBand;
extern volatile uint16_t smeterValue;
extern volatile uint8_t smeterUpdateCounter;

extern uint32_t freq_max[8];
extern uint32_t freq_min[8];
extern uint32_t frequency_1[8];
extern const char* band_names[8];

#endif