
#ifndef FONTS_H
#define FONTS_H

#include <avr/pgmspace.h>
#include <stdint.h>

// Структура для описания шрифта
typedef struct {
    const uint8_t *data;
    uint8_t width;
    uint8_t height;
    uint8_t first_char;
    uint8_t last_char;
} FontDef;

// Шрифт 5x7
extern const uint8_t font_5x7_data[95][5];
extern const FontDef font_5x7;

// Шрифт 8x16
extern const uint8_t font_8x16_data[95][16];
extern const FontDef font_8x16;

// Функции для работы со шрифтами
uint8_t font_get_char_width(const FontDef *font, char c);
uint8_t font_get_string_width(const FontDef *font, const char *str);
const uint8_t* font_get_char_data(const FontDef *font, char c);

#endif
