
#ifndef OLED_SSD1306_H
#define OLED_SSD1306_H

#include <avr/io.h>
#include <util/delay.h>
#include "i2c.h"
#include "fonts.h"

#define OLED_WIDTH   128
#define OLED_HEIGHT  32

// Прототипы функций
void oled_init(void);
void oled_clear(void);
void oled_send_command(uint8_t cmd);
void oled_send_data(uint8_t data);
void oled_draw_frequency(uint32_t freq);
void oled_write_char(uint8_t x, uint8_t y, char c, const FontDef *font);
void oled_write_string(uint8_t x, uint8_t y, const char *str, const FontDef *font);
void oled_update(void);
void oled_clear_line(uint8_t y);

// Функции для обратной совместимости
void oled_write_char_small(uint8_t x, uint8_t y, char c);
void oled_write_string_small(uint8_t x, uint8_t y, const char *str);
void oled_write_char_large(uint8_t x, uint8_t y, char c);
void oled_write_string_large(uint8_t x, uint8_t y, const char *str);

#endif
