#ifndef I2C_H
#define I2C_H

#include <avr/io.h>

// I2C адреса устройств
#define SI5351_ADDRESS      0xC0
#define OLED_ADDRESS        0x78 

// Статус коды I2C
#define I2C_SUCCESS         0
#define I2C_ERROR_NACK      1
#define I2C_ERROR           2

// TWI Status Codes
#define TW_START            0x08
#define TW_REP_START        0x10
#define TW_MT_SLA_ACK       0x18
#define TW_MT_SLA_NACK      0x20
#define TW_MT_DATA_ACK      0x28
#define TW_MT_DATA_NACK     0x30
#define TW_MR_SLA_ACK       0x40
#define TW_MR_SLA_NACK      0x48
#define TW_MR_DATA_ACK      0x50
#define TW_MR_DATA_NACK     0x58

void i2cInit(void);
uint8_t i2cStart(uint8_t address);
uint8_t i2cRepeatedStart(uint8_t address);
void i2cStop(void);
uint8_t i2cWrite(uint8_t data);
uint8_t i2cReadAck(void);
uint8_t i2cReadNack(void);
uint8_t i2cSendRegister(uint8_t reg, uint8_t data);
uint8_t i2cReadRegister(uint8_t devAddr, uint8_t reg, uint8_t *data);

uint8_t i2cByteSend(uint8_t data);

#endif